<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use Bookly\Lib\Utils\Common;
/** @var \Bookly\Lib\UserBookingData $userData */

$bookly_swich_hide_email = get_option('bookly_swich_hide_email');
?>
<div class="bookly-form-group" style="<?php $bookly_swich_hide_email == "1" ? esc_attr_e("display: none") : ""  ?>" >
    <label><?php echo Common::getTranslatedOption( 'bookly_l10n_label_email' ) ?></label>
    <div>
        <input class="bookly-js-user-email" maxlength="255" type="text" value="<?php esc_attr_e( $userData->getEmail() ) ?>"/>
    </div>
    <div class="bookly-js-user-email-error bookly-label-error"></div>
</div>