<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use Bookly\Backend\Components\Controls\Buttons;
use Bookly\Backend\Components\Controls\Inputs;
use Bookly\Backend\Components\Support\Lib\Urls;
use Bookly\Lib\Utils;
/**
 * @var array $demo_links
 * @var bool $show_contact_us_notice
 * @var bool $show_feedback_notice
 */
/**
 * View demo
 */
?>
<?php
    if ( isset ( $demo_links[ $page_slug ] ) ) :
        $target = Utils\Common::prepareUrlReferrers( $demo_links[ $page_slug ], 'demo' );
        $dismiss = get_user_meta( get_current_user_id(), 'bookly_dismiss_demo_site_description', true );
?>
    <div class="col-auto">
        <a class="btn btn-default" title="<?php esc_attr_e( 'View this page at Bookly Pro Demo', 'bookly' ) ?>"
            <?php if ( $dismiss ) : ?>
                href="<?php echo esc_attr( $target ) ?>"
            <?php else : ?>
                href="#bookly-demo-site-info-modal"  data-toggle="bookly-modal"
            <?php endif ?>
        >
            <i class="fas fa-fw fa-certificate"></i><span class="d-none d-lg-inline ml-2"><?php esc_html_e( 'View this page at Bookly Pro Demo', 'bookly' ) ?></span>
        </a>
        <?php if ( ! $dismiss ) : ?>
        <div id="bookly-demo-site-info-modal" class="bookly-modal bookly-fade text-left" tabindex=-1>
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php esc_html_e( 'Visit demo', 'bookly' ) ?></h5>
                        <button type="button" class="close" data-dismiss="bookly-modal" aria-label="Close"><span>&times;</span></button>
                    </div>
                    <div class="modal-body">
                        <p>
                            <?php esc_html_e( 'The demo is a version of Bookly Pro with all installed add-ons so that you can try all the features and capabilities of the system and then choose the most suitable configuration according to your business needs.', 'bookly' ) ?>
                        </p>

                        <div class="custom-control custom-checkbox">
                            <input class="custom-control-input form-check-input" id="bookly-js-dont-show-again-demo" type="checkbox"/>
                            <label class="custom-control-label" for="bookly-js-dont-show-again-demo"><?php esc_html_e( 'don\'t show this notification again', 'bookly' ) ?></label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <?php Buttons::renderSubmit( null, 'bookly-js-proceed-to-demo', __( 'Proceed to demo', 'bookly' ), array( 'data-target' => $target ) ) ?>
                        <?php Buttons::renderCancel() ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif ?>
    </div>
<?php endif ?>

<?php
/**
 * Documentation
 */
?>
<div class="col-auto">
    <a href="<?php echo esc_url( 'https://proje724.ir/learn-how-to-use-a-bookly/' ) ?>" target="_blank" class="btn btn-default" title="<?php esc_attr_e( '', 'bookly' ) ?>">
        <i class="far fa-question-circle"></i><span class="d-none d-lg-inline ml-2"><?php esc_html_e( ' مستندات', 'bookly' ) ?></span>
    </a>
</div>
<div class="col-auto">
    <a href="<?php echo esc_url( 'https://www.zhaket.com/web/bookly-reservation/?affid=AF-6132654b963d9' ) ?>" id="bookly-help-btn" target="_blank" class="btn btn-default" title="<?php esc_attr_e( '', 'bookly' ) ?>">
        <i class="fa fa-shopping-cart"></i><span class="d-none d-lg-inline ml-2"><?php esc_html_e( ' خرید افزونه', 'bookly' ) ?></span>
    </a>
</div>