<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use Bookly\Backend\Components\Controls\Buttons;
use Bookly\Backend\Components\Controls\Inputs as ControlsInputs;
use Bookly\Backend\Components\Settings\Inputs;
use Bookly\Backend\Components\Settings\Selects;
use Bookly\Lib\Entities\CustomerAppointment;
use Bookly\Backend\Modules\Settings\Proxy;
use Bookly\Backend\Components\Settings;

?>
<form method="post" action="<?php echo esc_url( add_query_arg( 'tab', 'pro724_settings' ) ) ?>">
    <div class="card-body">
    <?php
		Selects::renderSingle( 'bookly_is_show_end_time_is_slot', __( 'Display the end time in the slot', 'bookly' ), __( 'Display the end time next to the start time of the slot at the time of booking', 'bookly' ) ); // proje724
        Inputs::renderText( 'bookly_gen_service_slot_title', __( 'Set slot title', 'bookly' ), __( 'You can specify the title of the slots based on the WordPress template. read more https://wordpress.org/support/article/formatting-date-and-time/', 'bookly' ) ); // proje724
        Selects::renderSingle( 'bookly_validation_just_iran_operator', __( 'اعتبار سنجي شماره موبايل‌هاي ايران' ), __( 'شماره موبايل‌هاي ايرانسل و همراه اول و رايتل و تاليا و شاتل موبايل بر اساس الگو قابل شناسايي است، شماره‌هاي ديگر را قبول نمي‌کند.(بايد اجباري‌بودن شماره موبايل در ويرايش ظاهري فعال کرده باشيد)', 'bookly' ) ); // proje724
        Selects::renderSingle( 'bookly_toggle_start_with_endـtime', __( 'جا‌به‌جايي فيلد ساعت شروع و پايان' ), __( 'بر اساس direction قالب‌ها ممکن است فيلد زمان شروع و پايان براي شما جا‌به‌جا نمايش داده‌شود. مي‌تونيد با فعال کردن اين گزينه آن‌ را اصلاح کنيد.', 'bookly' ) ); // proje724
		Selects::renderSingle('bookly_swich_lang_change_calendar_miladi', __('تغییر تقویم فرم‌رزرو'), __('با توجه به زبانی که کاربر انتخاب می‌کند، تقویم میلادی و یا شمسی نمایش داده می‌شود در فرم رزرو برای کاربر', 'bookly'));
		Selects::renderSingle('bookly_swich_hide_email', __('مخفی کردن ایمیل'), __('برای کارکرد صحیح از بخش <b>تنظیمات » مشتریان ایجاد حساب کاربری</b> باید غیرفعال شود بعد از این از بخش سفارشی کردن فقط تلفن همراه فعال باشد.', 'bookly'));
		Selects::renderSingle('bookly_toggle_main_calendar_milady', __('تغییر تقویم اصلی بوکلی به میلادی'), __('با فعال کردن این گزینه، تقویم اصلی بوکلی به تقویم میلادی برمی‌گرده و می‌تونید رزرو‌های کاربر را به صورت میلادی مشاهده کنید. به این شکل تقویمی با امکانات بیشتر دارید.', 'bookly'));
		Inputs::renderTextArea( 'bookly_terms_conditions', __( 'متن قوانین و شرایط', 'bookly' ), __( 'اگر میخواهید شرایطی برای تایید رزرو تعریف کنید در این فیلد این متن را وارد نمائید تا کاربر هنگام رزو تایید و تکمیل کند.', 'bookly' ) ); 
    ?>
    </div>
    <div class="card-footer bg-transparent d-flex justify-content-end">
        <?php ControlsInputs::renderCsrf() ?>
        <?php Buttons::renderSubmit() ?>
        <?php Buttons::renderReset( null, 'ml-2' ) ?>
    </div>
</form>
<br>
<br>
		<div class="m-3">
		<div class="bookly-card-highlighted border-danger card p-3 mb-3">
				<div class="row">
					<div class="col-lg-10 col-md-9 col-xs-7">
						<div class="row">
							<div class="col-lg-4 col-md-6">
								<div class="d-flex">
									<div class="mr-4 mb-4">
										<a href="https://zhaket.com/product/bookly-custom-fields/" target="_blank"><img src="https://s3.envato.com/files/276918414/bookly-icon-(1)%20(3).png"></a>
									</div>
									<div class="flex-fill">
										<div class="h5"><a href="https://zhaket.com/product/bookly-custom-fields/" target="_blank">فیلد سفارشی بوکلی</a> <span class="badge badge-danger"></span></div>
										<a class="" href="https://www.zhaket.com/store/web/proje724" target="_blank">همه محصولات ما</a>
									</div>
								</div>
							</div>
							<div class="col-lg-8 col-md-6">با نصب افزونه فیلدهای سفارشی بوکلی شما در مرحل رزرو مشتری میتوانید فیلد های متنی انتخابی ایجاد کنید به عنوان مثال فیلد اطلاعات تماس، جنسیت، سن، آدرس و هر آیتم دیگری که احساس میکنید نیاز هست. با این افزونه میتوانید پرسشنامه های خود را در هنگام رزرو ایجاد کنید. </div>
						</div>
					</div>
					<div class="col-lg-2 col-md-3 col-xs-5">
						<div class="text-center">
							<a href="https://zhaket.com/product/bookly-custom-fields/" class="btn btn-default" target="_blank">مشاهده افزودنی</a><br>
							<div>پیشنهادی</div>
						</div>
					</div>
				</div>
			</div>
	</div>
	
			<div class="m-3">
		<div class="bg-light card p-3 mb-3">
				<div class="row">
					<div class="col-lg-10 col-md-9 col-xs-7">
						<div class="row">
							<div class="col-lg-4 col-md-6">
								<div class="d-flex">
									<div class="mr-4 mb-4">
										<a href="https://zhaket.com/product/bookly-coupons-add-on/" target="_blank"><img src="https://s3.envato.com/files/276918414/bookly-icon-(1)%20(3).png"></a>
									</div>
									<div class="flex-fill">
										<div class="h5"><a href="https://zhaket.com/product/bookly-coupons-add-on/" target="_blank">کد تخفیف بوکلی</a> <span class="badge badge-danger"></span></div>
										<a class="" href="https://www.zhaket.com/store/web/proje724" target="_blank">همه محصولات ما</a>
									</div>
								</div>
							</div>
							<div class="col-lg-8 col-md-6">برای مشتریان سایت می باشد با کمک این افزونه میتوانید در کنار افزونه بوکلی برای مشتریانی که وقت رزرو میکنید بر پایه جشنجواره یا خرید های قبلی تخفیف های جذاب ایجاد کنید</div>
						</div>
					</div>
					<div class="col-lg-2 col-md-3 col-xs-5">
						<div class="text-center">
							<a href="https://zhaket.com/product/bookly-coupons-add-on/" class="btn btn-default" target="_blank">مشاهده افزودنی</a><br>
						</div>
					</div>
				</div>
			</div>
	</div>
	
			<div class="m-3">
		<div class="bg-light card p-3 mb-3">
				<div class="row">
					<div class="col-lg-10 col-md-9 col-xs-7">
						<div class="row">
							<div class="col-lg-4 col-md-6">
								<div class="d-flex">
									<div class="mr-4 mb-4">
										<a href="https://zhaket.com/product/bookly-cart-add-on/" target="_blank"><img src="https://s3.envato.com/files/276918414/bookly-icon-(1)%20(3).png"></a>
									</div>
									<div class="flex-fill">
										<div class="h5"><a href="https://zhaket.com/product/bookly-cart-add-on/" target="_blank">رزرو همزمان چند وقت</a> <span class="badge badge-danger"></span></div>
										<a class="" href="https://www.zhaket.com/store/web/proje724" target="_blank">همه محصولات ما</a>
									</div>
								</div>
							</div>
							<div class="col-lg-8 col-md-6">پس با این افزونه مشتریان به سادگی میتوانند چند وقت انتخاب کنند و در نهایت قیمت کلی را یکبار پرداخت کنند. </div>
						</div>
					</div>
					<div class="col-lg-2 col-md-3 col-xs-5">
						<div class="text-center">
							<a href="https://zhaket.com/product/bookly-cart-add-on/" class="btn btn-default" target="_blank">مشاهده افزودنی</a><br>
						</div>
					</div>
				</div>
			</div>
	</div>
	
			<div class="m-3">
		<div class="bg-light card p-3 mb-3">
				<div class="row">
					<div class="col-lg-10 col-md-9 col-xs-7">
						<div class="row">
							<div class="col-lg-4 col-md-6">
								<div class="d-flex">
									<div class="mr-4 mb-4">
										<a href="https://zhaket.com/product/bookly-locations/" target="_blank"><img src="https://s3.envato.com/files/276918414/bookly-icon-(1)%20(3).png"></a>
									</div>
									<div class="flex-fill">
										<div class="h5"><a href="https://zhaket.com/product/bookly-locations/" target="_blank">انتخاب مکان شهر</a> <span class="badge badge-danger"></span></div>
										<a class="" href="https://www.zhaket.com/store/web/proje724" target="_blank">همه محصولات ما</a>
									</div>
								</div>
							</div>
							<div class="col-lg-8 col-md-6">با کمک این افزونه مدیر میتواند شهر هایی که خدمات نوبت دهی میدهد را اضاف کنید و همینطور توضیحات یا همان جزئیات بیشتر آدرس را درج کند</div>
						</div>
					</div>
					<div class="col-lg-2 col-md-3 col-xs-5">
						<div class="text-center">
							<a href="https://zhaket.com/product/bookly-locations/" class="btn btn-default" target="_blank">مشاهده افزودنی</a><br>
						</div>
					</div>
				</div>
			</div>
	<br>
	</div>