<?php
namespace ElementsKit\Hooks;

defined( 'ABSPATH' ) || exit;


class Register_Widgets{
    use \ElementsKit\Traits\Singleton;

    public function __construct(){
        add_filter( 'elementskit/widgets/list', [$this, 'get_list'] );
    }


    public function get_list($list){


        return array_merge($list, [
            'blog-posts' => [
                'slug'    => 'blog-posts',
                'title'   => 'Blog Posts',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'blog-posts/',
                'widget-category' => 'wp-posts' // Post Widgets
            ],
            'advanced-accordion' => [
                'slug'    => 'advanced-accordion',
                'title'   => 'آکاردئون پیشرفته',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'advanced-accordion/',
                'widget-category' => 'general' // General
            ],
            'advanced-tab'       => [
                'slug'    => 'advanced-tab',
                'title'   => 'تب پیشرفته',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'advanced-tab/',
                'widget-category' => 'general' // General
            ],
            'hotspot'            => [
                'slug'    => 'hotspot',
                'title'   => 'Hotspot',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'hotspot/',
                'widget-category' => 'general' // General
            ],
            'motion-text'        => [
                'slug'    => 'motion-text',
                'title'   => 'متن متحرک',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'motion-text/',
                'widget-category' => 'general' // General
            ],
            'twitter-feed'       => [
                'slug'    => 'twitter-feed',
                'title'   => 'فید توییتر',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'twitter-feed/',
                'widget-category' => 'social-media-feeds' // Social Media Feeds Widgets
            ],
    
            'instagram-feed'       => [
                'slug'    => 'instagram-feed',
                'title'   => 'فید اینستاگرام',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'instagram-feed/',
                'widget-category' => 'social-media-feeds' // Social Media Feeds Widgets
            ],
            'gallery'              => [
                'slug'    => 'gallery',
                'title'   => 'گالری',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'gallery/',
                'widget-category' => 'general' // General
            ],
            'whatsapp'     => [
                'slug'    => 'whatsapp',
                'title'   => 'واتساپ',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'whatsapp/',
                'widget-category' => 'general' // General
            ],
            'chart'                => [
                'slug'    => 'chart',
                'title'   => 'نمودار',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'chart/',
                'widget-category' => 'general' // General
            ],
            'woo-category-list'    => [
                'slug'    => 'woo-category-list',
                'title'   => 'لیست دسته بندی ووکامرس',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'woo-category-list/',
                'widget-category' => 'woocommerce' // Woocommerce Widgets
            ],
            'woo-mini-cart'        => [
                'slug'    => 'woo-mini-cart',
                'title'   => 'سبد خرید کوچک ووکامرس',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'woo-mini-cart/',
                'widget-category' => 'woocommerce' // Woocommerce Widgets
            ],
            'woo-product-carousel' => [
                'slug'    => 'woo-product-carousel',
                'title'   => 'کاروسل محصول ووکامرس',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'woo-product-carousel/',
                'widget-category' => 'woocommerce' // Woocommerce Widgets
            ],
            'woo-product-list'     => [
                'slug'    => 'woo-product-list',
                'title'   => 'لیست محصول ووکامرس',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'woo-product-list/',
                'widget-category' => 'woocommerce' // Woocommerce Widgets
            ],
            'table'                => [
                'slug'    => 'table',
                'title'   => 'جدول',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'table/',
                'widget-category' => 'general' // General
            ],
            'timeline'             => [
                'slug'    => 'timeline',
                'title'   => 'تایم لاین',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'timeline/',
                'widget-category' => 'general' // General
            ],
            'creative-button'      => [
                'slug'    => 'creative-button',
                'title'   => 'دکمه خلاقانه',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'creative-button/',
                'widget-category' => 'general' // General
            ],
            'vertical-menu'        => [
                'slug'    => 'vertical-menu',
                'title'   => 'منوی عمودی',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'vertical-menu/',
                'widget-category' => 'header-footer' // ElementsKit Header Footer
            ],
            'advanced-toggle'      => [
                'slug'    => 'advanced-toggle',
                'title'   => 'تاگل پیشرفته',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'advanced-toggle/',
                'widget-category' => 'general' // General
            ],
            'image-swap'           => [
                'slug'    => 'image-swap',
                'title'   => 'Image Swap',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'image-swap/',
                'widget-category' => 'general' // General
            ],
            'video-gallery'        => [
                'slug'    => 'video-gallery',
                'title'   => 'گالری ویدئو',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'video-gallery/',
                'widget-category' => 'general' // General
            ],
            'zoom'                 => [
                'slug'    => 'zoom',
                'title'   => 'زوم',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'zoom/',
                'widget-category' => 'meeting-widgets' // Meeting Widgets
            ],
            'behance-feed'         => [
                'slug'    => 'behance-feed',
                'title'   => 'Behance Feed',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'behance-feed/',
                'widget-category' => 'social-media-feeds' // Social Media Feeds Widgets
            ],
    
            'breadcrumb' => [
                'slug'    => 'breadcrumb',
                'title'   => 'مسیر کاربر',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'breadcrumb/',
                'widget-category' => 'general' // General
            ],
    
            'dribble-feed' => [
                'slug'    => 'dribble-feed',
                'title'   => 'Dribble Feed',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'dribble-feed/',
                'widget-category' => 'social-media-feeds' // Social Media Feeds Widgets
            ],
    
            'facebook-feed' => [
                'slug'    => 'facebook-feed',
                'title'   => 'فید فیس بوک',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'facebook-feed/',
                'widget-category' => 'social-media-feeds' // Social Media Feeds Widgets
            ],
    
            'facebook-review' => [
                'slug'    => 'facebook-review',
                'title'   => 'Facebook review',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'facebook-review/',
                'widget-category' => 'review-widgets' // Review Widgets
            ],
            'yelp' => [
                'slug'    => 'yelp',
                'title'   => 'Yelp',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'yelp/',
                'widget-category' => 'review-widgets' // Review Widgets
            ],
            'popup-modal' => [
                'slug'    => 'popup-modal',
                'title'   => 'پنجره پاپ اپ',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'popup-modal/',
                'widget-category' => 'general' // General
            ],
            'google-map' => [
                'slug'    => 'google-map',
                'title'   => 'نقشه گوگل',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'google-map/',
                'widget-category' => 'general' // General 
            ],
            'unfold' => [
                'slug'    => 'unfold',
                'title'   => 'Unfold',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'unfold/',
                'widget-category' => 'general' // General 
            ],
    
            'pinterest-feed' => [
                'slug'    => 'pinterest-feed',
                'title'   => 'فید پینترست',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'pinterest-feed/',
                'widget-category' => 'social-media-feeds' // Social Media Feeds Widgets
            ],
            'advanced-slider' => [
                'slug'    => 'advanced-slider',
                'title'   => 'اسلایدر پیشرفته',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'advanced-slider/',
                'widget-category' => 'general' // General
            ],
			'image-hover-effect' => [
                'slug'    => 'image-hover-effect',
                'title'   => 'افکت هاور تصویر',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'image-hover-effect/',
                'widget-category' => 'general' // General
            ],            
            'fancy-animated-text' => [
                'slug'    => 'fancy-animated-text',
                'title'   => 'متن متحرک فانتزی',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'fancy-animated-text/',
                'widget-category' => 'general' // General
            ],
            'price-menu' => [
                'slug'    => 'price-menu',
                'title'   => 'منوی قیمت',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'price-menu/',
                'widget-category' => 'general' // General
            ],
			'stylish-list' => [
                'slug'    => 'stylish-list',
                'title'   => 'Stylish List',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'stylish-list/',
                'widget-category' => 'general' // General
            ],
            'team-slider' => [
                'slug'    => 'team-slider',
                'title'   => 'اسلایدر کاروسل تیم',
                'package' => 'pro',
                'path'    => \ElementsKit::widget_dir() . 'team-slider/',
                'widget-category' => 'general' // General
            ],
			'audio-player' => [
				'slug'    => 'audio-player',
				'title'   => 'پخش کننده صدا',
				'package' => 'pro',
				'path'    => \ElementsKit::widget_dir() . 'audio-player/',
				'widget-category' => 'general' // General
			],
			'flip-box' => [
				'slug'    => 'flip-box',
				'title'   => 'فلیپ باکس',
				'package' => 'pro',
				'path'    => \ElementsKit::widget_dir() . 'flip-box/',
				'widget-category' => 'general' // General
			],
			'image-morphing' => [
				'slug'    => 'image-morphing',
				'title'   => 'شکل‌گیری تصویر',
				'package' => 'pro',
				'path'    => \ElementsKit::widget_dir() . 'image-morphing/',
				'widget-category' => 'general' // General
			],
        ]);
    }
}